<?php
/*
Widget Name: Repeater box with background image and builder
Description: 
*/

class Box_rep11 extends SiteOrigin_Widget {

	function get_template_name($instance) {
    return 'widget-template';
}

function get_template_dir($instance) {
    return 'templates';
}

function __construct() {
   
    //Call the parent constructor with the required arguments.
    parent::__construct(
        // The unique id for your widget.
        'box-rep11',

        // The name of the widget for display purposes.
        'Repeater box with background image and builder',

        // The $widget_options array, which is passed through to WP_Widget.
        // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
        array(
            'panels_groups' => array('nh')
        ),

        //The $control_options array, which is passed through to WP_Widget
        array(
        ),

        //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
		array(
			'cust_class' => array(
				'type' => 'text',
				'label' => __('Custom Class(do not delete)', 'widget-form-fields-text-domain'),
				'default' => ''
			),
			'list_item' => array(
				'type' => 'repeater',
				'label' => __( 'List item' , 'widget-form-fields-text-domain' ),
				'item_name'  => __( 'Text', 'siteorigin-widgets' ),
				'item_label' => array(
					 'selector'     => "[id*='title_text']",
					 'update_event' => 'change',
					 'value_method' => 'val'
				),
				'fields' => array(
					'icon_bg' => array(
						'type' => 'media',
						'label' => __( 'Image', 'widget-form-fields-text-domain' ),
						'choose' => __( 'Choose image', 'widget-form-fields-text-domain' ),
						'update' => __( 'Set image', 'widget-form-fields-text-domain' ),
						'library' => 'image',
						'fallback' => true
					),
					'title_text' => array(
						'type' => 'textarea',
						'label' => __( 'Title Text', 'widget-form-fields-text-domain' ),
						'default' => '',
						'rows' => 10
					),
					'link_title' => array(
						'type' => 'link',
						'label' => __('Link title(optional)', 'widget-form-fields-text-domain'),
					),
					'target_link' => array(
						'type' => 'select',
						'label' => __( 'Target Link', 'widget-form-fields-text-domain' ),
						'default' => '_self',
						'options' => array(
							'_self' => __( 'Same tab', 'widget-form-fields-text-domain' ),
							'_blank' => __( 'New tab', 'widget-form-fields-text-domain' ),
							
						)
					),
				 
				)
			)
        ),

        //The $base_folder path string.
        plugin_dir_path(__FILE__)
    );
}
}

siteorigin_widget_register('box-rep11', __FILE__, 'Box_rep11');