<?php
/*
Widget Name: Slider - header
Description: 
*/

class Clie_slider extends SiteOrigin_Widget {

	function get_template_name($instance) {
    return 'widget-template';
}

function get_template_dir($instance) {
    return 'templates';
}

function __construct() {
   
    //Call the parent constructor with the required arguments.
    parent::__construct(
        // The unique id for your widget.
        'clie-slider',

        // The name of the widget for display purposes.
        'Slider - header (with builder inside)',

        // The $widget_options array, which is passed through to WP_Widget.
        // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
        array(
            'panels_groups' => array('nh')
        ),

        //The $control_options array, which is passed through to WP_Widget
        array(
        ),

        //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
        array(
			'class_custom' => array(
				'type' => 'text',
				'label' => __('Custom Class (do not delete)', 'widget-form-fields-text-domain'),
				'default' => ''
			),

			'list_item' => array(
				'type' => 'repeater',
				'label' => __( 'Slider Header' , 'widget-form-fields-text-domain' ),
				'item_name'  => __( 'Slide item', 'siteorigin-widgets' ),
				'item_label' => array(
					'selector'     => "[id*='title_head']",
					'update_event' => 'change',
					'value_method' => 'val'
				),
				'fields' => array(	
					'icon' => array(
						'type' => 'media',
						'label' => __( 'Image Background', 'widget-form-fields-text-domain' ),
						'choose' => __( 'Choose image', 'widget-form-fields-text-domain' ),
						'update' => __( 'Set image', 'widget-form-fields-text-domain' ),
						'library' => 'image',
						'fallback' => true
					),

					'builder_cont_tab' => array(
						'type' => 'builder',
						'label' => __( 'Content Area', 'widget-form-fields-text-domain'),
					),

				)
			),
        ),

        //The $base_folder path string.
        plugin_dir_path(__FILE__)
    );
}
}



siteorigin_widget_register('clie-slider', __FILE__, 'Clie_slider');